<div class="project-grid-carousel-active id-<?php echo $dynamic_id; ?>">
    <?php
        global $post;
        $args = array(
            'post_type'             => 'project',
            'post_status'           => 'publish',
            'order'                 => !empty($settings['post_order']) ? $settings['post_order'] : 'DESC',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => !empty($settings['post_limit']) ? $settings['post_limit'] : 8,
        );
        $the_query = new \WP_Query($args);
        while ($the_query->have_posts()) : $the_query->the_post();

        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
        $author_id = get_the_author_meta( 'ID' ); 
    ?>
        <div class="single-project-grid bg-cover style-1" style="background-image: url('<?php echo esc_url($featured_img_url); ?>');">
            <div class="project-details">
                <div class="project-cat">
                    <?php 
                        $categories = get_the_terms( get_the_ID() , 'project_cat' );
                        if ( ! empty( $categories ) ) {
                            echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a>';
                        }
                    ?>
                </div>
                <h3><a href="<?php the_permalink(); ?>"><?php echo esc_html( get_the_title() ); ?></a></h3>
                <?php if( 'yes' == $settings['show_read_more_btn']) : ?>
                <div class="read-more-btn">
                    <a href="<?php the_permalink(); ?>"><?php echo esc_html( $settings['read_more_text'] ); ?> <i class="fal fa-plus"></i></a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endwhile; ?>
    <?php wp_reset_postdata(); ?>
</div>

<script>
    (function ( $ ) {
        "use strict";
        $(document).ready( function() {
            $('.project-grid-carousel-active.id-<?php echo $dynamic_id; ?>').slick({
                autoplay: <?php echo $autoplay; ?>,
                infinite: <?php echo $infinite; ?>,
                speed: <?php echo $autoplaytimeout; ?>,
                slidesToShow: <?php echo $slidestoshow; ?>,
                slidesToScroll: <?php echo $slidestoscroll; ?>, 
                arrows: false,
                dots: false,
                responsive: [
                    {
                        breakpoint: 1191,
                        settings: {
                            slidesToShow: 3,
                            center: true,
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2,
                            center: true,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 1,
                            center: true,
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1
                        }
                    },
                ],
            });
        });
    }( jQuery ));
</script>