<?php
namespace ModinaCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Modina_section_title extends Widget_Base {

    public function get_name() {
        return 'modina_section_title';
    }

    public function get_title() {
        return esc_html__( 'Section Title', 'modina-core' );
    }

    public function get_icon() {
        return 'eicon-t-letter';
    }

    public function get_keywords() {
        return [ 'title', 'section', 'transland', 'heading', 'modina'];
    }

    public function get_categories() {
        return [ 'modina-elements' ];
    }

    protected function register_controls() {

        // -------------------  Title Section  -----------------------//
        $this->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__( 'Section Heading', 'modina-core' ),
            ]
        );

        $this->add_control(
            'heading',
            [
                'label' => esc_html__( 'Heading Text', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Company <span>Overview</span>',
            ]
        );

        $this->add_control(
            'color_heading', [
                'label' => esc_html__( 'Heading Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .block-contents .section-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'color_heading_span', [
                'label' => esc_html__( 'Heading Span Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .block-contents .section-title h2 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_heading',
                'selector' => '{{WRAPPER}} .block-contents .section-title h2',
            ]
        );

        $this->end_controls_section(); 

        // ------------------- Sub Title Section  -----------------------//
        $this->start_controls_section(
            'section_sub_heading',
            [
                'label' => esc_html__( 'Section Sub Heading', 'modina-core' ),
            ]
        );

        $this->add_control(
            'sub_heading',
            [
                'label' => esc_html__( 'Sub Heading', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Since from 2000',
            ]
        );

        $this->add_control(
            'color_sub_heading', [
                'label' => esc_html__( 'Sub Heading Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .block-contents .section-title > span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'color_line_sub_heading', [
                'label' => esc_html__( 'Line Background Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .block-contents .section-title > span::before ' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_sub_heading',
                'selector' => '{{WRAPPER}} .block-contents .section-title > span',
            ]
        );

        $this->end_controls_section(); 

        $this->start_controls_section(
            'section_big_text',
            [
                'label' => esc_html__( 'Big Transparent Text', 'modina-core' ),
            ]
        );
        
        $this->add_control(
            'big_transparent_text',
            [
                'label' => esc_html__( 'Transparent Heading', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'about',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_big_heading',
                'selector' => '{{WRAPPER}} .block-contents .section-title h5',
            ]
        );
        
        $this->end_controls_section(); 

        // ------------------- Section Text  -----------------------//
        $this->start_controls_section(
            'section_text_tab',
            [
                'label' => esc_html__( 'Section Text Content', 'modina-core' ),
            ]
        );

        $this->add_control(
            'section_text',
            [
                'label' => esc_html__( 'Text', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'color_section_text', [
                'label' => esc_html__( 'Text Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .block-contents p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_sec_text',
                'selector' => '{{WRAPPER}} .block-contents p',
            ]
        );

        $this->end_controls_section(); 


        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Section Alignment', 'modina-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label' => __( 'Alignment', 'modina-core' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => __( 'Left', 'modina-core' ),
                        'icon' => 'fas fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'modina-core' ),
                        'icon' => 'fas fa-align-center',
                    ],
                    'end' => [
                        'title' => __( 'Right', 'modina-core' ),
                        'icon' => 'fas fa-align-right',
                    ],
                ],
                'default' => 'start',
                'toggle' => true,
            ]
        );

        $this->end_controls_section(); 

    }

    protected function render() {
    $settings = $this->get_settings();
    ?>

    <?php if (!empty($settings['heading'])) : ?>
    <div class="block-contents text-<?php echo esc_attr( $settings['text_align'] ); ?>">
        <div class="section-title">
            <h5 class="text-<?php echo esc_attr( $settings['text_align'] ); ?>"><?php echo htmlspecialchars_decode(esc_html($settings['big_transparent_text'])); ?></h5>
            <span><?php echo htmlspecialchars_decode(esc_html($settings['sub_heading'])); ?></span>
            <h2><?php echo htmlspecialchars_decode(esc_html($settings['heading'])); ?></h2>
        </div>
        <?php if (!empty($settings['section_text'])) : ?>
            <p><?php echo htmlspecialchars_decode(esc_html($settings['section_text'])); ?></p>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <?php
    }
}