<?php

namespace ModinaCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}


class Modina_our_branches extends Widget_Base
{

    public function get_name()
    {
        return 'modina_our_branches';
    }

    public function get_title()
    {
        return esc_html__('Office Branches Card', 'modina-core');
    }

    public function get_icon()
    {
        return 'eicon-map-pin';
    }

    public function get_keywords()
    {
        return ['office', 'branches', 'workplace', 'place', 'address', 'phone', 'map', 'modina'];
    }

    public function get_categories() {
        return [ 'modina-elements' ];
    }

    protected function register_controls() {


         // -------------------  Title Section  -----------------------//
        $this->start_controls_section(
            'section_contents',
            [
                'label' => esc_html__( 'Our Branches', 'modina-core' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'country_flag', [
                'label' => esc_html__( 'Country Flag Image', 'modina-core' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/flag-1.jpg',
                ],
            ]
        );

        $repeater->add_control(
            'country_branches_name',
            [
                'label' => esc_html__( 'Country & Branches Name', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'America, Los Angeles',
            ]
        );

        $repeater->add_control(
            'country_branches_address',
            [
                'label' => esc_html__( 'Address - Branches Office', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => '24/7, Global Factory Street, 2nd Cross, San Fransisco 94112.',
            ]
        );

        $repeater->add_control(
            'country_branches_phone',
            [
                'label' => esc_html__( 'Phone - Branches Office', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => '+61 (625) 07520-6644 & 6655',
            ]
        );

        $repeater->add_control(
            'country_branches_email',
            [
                'label' => esc_html__( 'Email - Branches Office', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'support@example.com',
            ]
        );
        
        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Link - All Branches', 'modina-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'modina-core' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
					'nofollow' => true,
                ],
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Title', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'All Branches',                
            ]
        );

        $this->add_control(
            'all_branches',
            [
                'label' => esc_html__( 'All Country Branches', 'modina-core' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'country_branches_name'   => 'America, Los Angeles',
                    ],
                ],
                'title_field' => '{{{country_branches_name}}}'
            ]
        );

        $this->end_controls_section(); 


        $this->start_controls_section(
            'style_branches_item', [
                'label' => esc_html__( 'Branches Item Style', 'modina-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_country_title',
                'selector' => '{{WRAPPER}} .single-branch-card h3',
            ]
        );

        $this->add_control(
            'b_color_title', [
                'label' => esc_html__( 'Branches Name Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-branch-card h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'b_color_line', [
                'label' => esc_html__( 'Branches Bottom Line Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-branch-card .content h4::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'b_color_email', [
                'label' => esc_html__( 'Branches Mail Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-branch-card .content p a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'b_color_link', [
                'label' => esc_html__( 'Branches Link Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-branch-card .content .branch-links a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'b_color_link_hover', [
                'label' => esc_html__( 'Branches Link Hover Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-branch-card .content .branch-links a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
        


    }

    protected function render() {

    $settings = $this->get_settings();
    $all_branches = $settings['all_branches'];
    ?>
    
    <?php if (!empty($all_branches)) : ?>
        <div class="row">
        <?php if (!empty($all_branches)) { $i = 0;
            foreach ($all_branches as $item) { $i++; ?>
            <div class="col-lg-4 col-md-6 col-12">
                <div class="single-branch-card">
                    <?php if( !empty($item['country_flag']['url'] ) ) : ?>
                    <div class="country-flag bg-cover bg-center" style="background-image: url('<?php echo esc_url($item['country_flag']['url']); ?>')"></div>
                    <?php endif; ?>
                    <div class="content">
                        <h4><?php echo htmlspecialchars_decode(esc_html($item['country_branches_name'])); ?></h4>
                        <p><?php echo htmlspecialchars_decode(esc_html($item['country_branches_address'])); ?></p>
                        <p><?php echo htmlspecialchars_decode(esc_html($item['country_branches_phone'])); ?></p>
                        <p><a href="mailto:<?php echo esc_attr( $item['country_branches_email'] ); ?>"><?php echo htmlspecialchars_decode(esc_html($item['country_branches_email'])); ?></a></p>

                        <?php if( !empty($item['btn_link']['url'] ) ) : ?>
                        <div class="branch-links">
                            <a href="<?php echo esc_url($item['btn_link']['url']); ?>" <?php modina_is_external($item['btn_link']); ?> <?php modina_is_nofollow($item['btn_link']); ?>><?php echo esc_html( $item['button_text'] ); ?> <i class="far fa-long-arrow-right"></i></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php }
        } ?>
        </div>
    <?php endif; ?>
<?php
    }
}
